<?php
// +------------------------------------------------------------------------+
// | @author: coder_mvn
// | @name: Zontal - The Arcade Online HTML5 Game Playing Platform
// | @author_email: mvk62015@gmail.com   
// | @version: 1.0v
// +------------------------------------------------------------------------+
// | Zontal - The Arcade Online HTML5 Game Playing Platform
// | Copyright (c) 2023 Zontal. All rights reserved.
// +------------------------------------------------------------------------+

require_once 'app/init.php';
include("auto-fetch.php");

if ($zon['config']['theme'] === 'garud') {
    ?>
    <!DOCTYPE html>
    <html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="keywords" content="<?php echo $zon['config']['site_keywords'] ?>" />
        <?php if ($zon['page'][0] == '') { ?>
            <?php # meta tags for home page       ?>
            <meta name="description" content="<?php echo $zon['config']['site_desc'] ?>" />
            <link rel="canonical" href="<?php echo $site_url ?>" />
            <meta property="og:title" content="<?php echo $zon['config']['site_title'] ?>">
            <meta property="og:type" content="website">
            <meta property="og:image" content="<?php echo $site_url . 'static/logo/' . $zon['config']['site_logo_light'] ?>">
            <meta property="og:url" content="<?php echo $site_url ?>">
            <meta property="og:description" content="<?php echo $zon['config']['site_desc'] ?>">
            <meta property="og:site_name" content="<?php echo $zon['config']['site_name'] ?>">
            <meta property="og:image:width" content="630" />
            <meta property="og:image:height" content="630" />
            <meta name="twitter:card" content="summary">
            <meta name="twitter:site" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:creator" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:title" content="<?php echo $zon['config']['site_title'] ?>">
            <meta name="twitter:description" content="<?php echo $zon['config']['site_desc'] ?>">
            <meta name="twitter:image" content="<?php echo $site_url . 'static/logo/' . $zon['config']['site_logo_light'] ?>">
            <meta name="twitter:image:alt" content="<?php echo $zon['config']['site_title'] ?>">
            <meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST'] ?>">
        <?php } ?>
        <?php if ($zon['page'][0] == 'game' && (count($zon['page']) == 3 || count($zon['page']) == 4) || $zon['page'][0] == 'single' && (count($zon['page']) == 3 || count($zon['page']) == 4)) {
            $play_title = $zon['config']['play_desc'];

            if ($zon['page'][0] == 'single') {
                $game = getGamesById($zon['page'][1]);
            }
            if ($zon['page'][0] == 'game') {
                $game = getGamesById($zon['page'][2]);
            }

            $game_desc = str_replace("[name]", $game['game_name'], $play_title);
            $game['game_description'] = $game_desc;
            ?>
            <meta name="description" content="<?php echo $game_desc ?>" />
            <link rel="canonical" href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>" />
            <meta property="og:title" content="<?php echo $game['game_name'] ?>">
            <meta property="og:type" content="website">
            <meta property="og:image" content="<?php echo $game['game_image_url'] ?>" />
            <meta property="og:url"
                content="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>">
            <meta property="og:description" content="<?php echo $game['game_description'] ?>">
            <meta property="og:site_name" content="<?php echo $zon['config']['site_name'] ?>">
            <meta property="og:image:width" content="630" />
            <meta property="og:image:height" content="630" />
            <meta name="twitter:card" content="summary">
            <meta name="twitter:site" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:creator" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:title" content="<?php echo $game['game_name'] ?>">
            <meta name="twitter:description" content="<?php echo $game['game_description'] ?>">
            <meta name="twitter:image" content="<?php echo $game['game_image_url'] ?>">
            <meta name="twitter:image:alt" content="<?php echo $game['game_name'] ?>">
            <meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST'] ?>">
        <?php } ?>
        <?php if ($zon['page'][0] == 'new-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'newest')) { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'popular-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'popular')) { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'games') { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'category' || $zon['page'][0] == 'game' && count($zon['page']) == 2) {
            $category_desc = $zon['config']['category_desc'];
            $title = str_replace("[name]", $_GET['n'] ?? '', $category_desc);
            ?>
            <meta name="description" content="<?php echo $title ?>" />
        <?php } ?>
        <meta name="robots" content="index, follow">
        <link rel="shortcut icon" href="<?php echo $site_url . 'static/img/logo/' . $zon['config']['site_favicon'] ?>"
            type="image/x-icon">
        <title>
            <?php getTitle(); ?>
        </title>
        <link rel="stylesheet" href="<?php echo $site_url ?>themes/<?php echo $zon['config']['theme'] ?>/css/style.css">
        <script src="<?php echo $site_url ?>js/tailwind.js"></script>
        <link rel="stylesheet" href="<?php echo $site_url ?>css/animate.css" />
        <script src="<?php echo $site_url ?>js/wow.min.js"></script>
        <script>zontal = { url: "<?php echo $site_url ?>", ui: <?php echo $zon['user']['id'] ?? 0; ?> }</script>
        <script src="<?php echo $site_url ?>js/toast.min.js"></script>
        <link rel="stylesheet" href="<?php echo $site_url ?>css/toast.min.css" />
        <?php echo $zon['config']['head_code'] ?>
        <style>
            :root {
                --zon-body-bg-color: #111;
                --zon-common-text-color: #111;
                --zon-theme-color:
                    <?php echo $zon['config']['site_color'] ?>
                ;
                --zon-div-color: #999;
                --zon-muted-color: #777;
                --zon-more-button-bg-color: #222;
                --zon-search-bg-color: #222;
                --zon-search-hover-color: #333;
                --zon-gmeta-bg-color: #222;
                --zon-overlay-bg-color: #000000af;
                --zon-cursor-color:
                    <?php echo $zon['config']['cursor_color'] ?>
                ;
                --zon-toggler-bg-color: #222;
                --zon-icon-color: #fff;
                --zon-dark-logo: block;
                --zon-light-logo: none;
                --zon-sidebar-shadow: 0px 0px 40px 0px #000;
                --zon-blog-social-button-bg-hover-color: #222;
                --zon-comment-input-b-color: #222;
            }
        </style>
    </head>

    <body>
        <?php
        LoadFile('header');
        if ($zon['page'][0] === '') {
            LoadFile('home');
        } else if ($zon['page'][0] === 'game' || $zon['page'][0] === 'single') {
            LoadFile('game');
        } else if ($zon['page'][0] === 'page') {
            LoadFile('page');
        } else if ($zon['page'][0] === 'category') {
            LoadFile('category');
        } else if ($zon['page'][0] === 'all-games') {
            LoadFile('all-games');
        } else if ($zon['page'][0] === 'new-games') {
            LoadFile('newest-games');
        } else if ($zon['page'][0] === 'popular-games') {
            LoadFile('popular-games');
        } else if ($zon['page'][0] === 'login') {
            LoadFile('login');
        } else if ($zon['page'][0] === 'register') {
            LoadFile('register');
        } else if ($zon['page'][0] === 'autoplay') {
            LoadFile('autoplay');
        } else if (num_rows(T_ZON_USERS, "username='" . $zon['page'][0] . "'") > 0) {
            if (IsLoggedin) {
                LoadFile('user-profile');
            }
        } else if ($zon['page'][0] === 'logout') {
            redirect('logout.php', 1);
        } else if ($zon['page'][0] === 'search') {
            LoadFile('search');
        } else {
            LoadFile('404');
        }
        ?>

        <hr class="mt-28">
        <footer class="zon-container">
            <ul class="flex">
                <?php foreach (getPages() as $page) { ?>
                    <li><a class="block px-4 hover:bg-[var(--zon-theme-color)] rounded-md hover:text-white transition duration-300 capitalize py-2 my-4 text-sm text-gray-600 "
                            href="<?= $site_url . 'page/' . $page['id'] . '/' . makeSlug($page['title']) ?>">
                            <?= $page['title'] ?>
                        </a></li>
                <?php } ?>
            </ul>
            <hr class="mb-6">
            <div class="footer-content">
                <?php echo $zon['config']['footer_content'] ?>
            </div>
            <hr class="mt-6">
            <div class="text-center text-sm capitalize py-3 text-gray-600 mt-2">©
                <?php echo $zon['config']['site_name'] ?>
                <?php echo date("Y") ?>
            </div>
        </footer>

        <script>
            var game = document.querySelectorAll(".home__game__grid .game");
            if (game.length > 0) {
                for (let i = 0; i < game.length; i++) {
                    if (i == 0) { game[i].classList.add("large"); }
                    if (i == 15) { game[i].classList.add("large"); }
                    if (i == 23) { game[i].classList.add("large"); }
                    if (i == 43) { game[i].classList.add("large"); }
                }
            }
        </script>
        <script> new WOW().init();  </script>
        <script src="<?php echo $site_url ?>themes/<?php echo $zon['config']['theme'] ?>/js/main.js"></script>
        <script src="<?php echo $site_url ?>js/jquery.min.js"></script>
        <script>
            $(document).on("click", (event) => {
                if (!event.target.closest(".search-drawer") && !event.target.closest(".search")) {
                    $("#drawer").removeClass("active");
                }

                if (!event.target.closest(".menu-drawer") && !event.target.closest(".menu")) {
                    $("#menu-drawer").removeClass("active");
                }
            })
        </script>
        <?php if ($zon['page'][0] == 'popular-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'popular')) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/popular-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'new-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'newest')) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/new-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'all-games') { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/all-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'category' || ($zon['page'][0] == 'game' && count($zon['page']) == 2)) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/games-by-category.php", {
                        page: page_no,
                        category: '<?php echo urldecode($_GET['n'] ?? $zon['page'][1]); ?>'
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
    </body>

    </html>
<?php } ?>
<?php if ($zon['config']['theme'] === 'zontal') {
    if ($zon['page'][0] == 'login') {
        if (IsLoggedin) {
            header("Location: ./");
        }
    }

    if ($zon['page'][0] == 'register') {
        if (IsLoggedin) {
            header("Location: ./");
        }
    }
    ?>
    <!DOCTYPE html>
    <html zontal-theme="dark" lang="en">

    <head>
        <meta charset="UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="stylesheet" href="<?php echo $site_url ?>themes/<?php echo $zon['config']['theme'] ?>/css/style.css" />
        <meta name="keywords" content="<?php echo $zon['config']['site_keywords'] ?>" />
        <?php if ($zon['page'][0] == '') { ?>
            <?php # meta tags for home page      ?>
            <meta name="description" content="<?php echo $zon['config']['site_desc'] ?>" />
            <link rel="canonical" href="<?php echo $site_url ?>" />
            <meta property="og:title" content="<?php echo $zon['config']['site_title'] ?>">
            <meta property="og:type" content="website">
            <meta property="og:image" content="<?php echo $site_url . 'static/logo/' . $zon['config']['site_logo_light'] ?>">
            <meta property="og:url" content="<?php echo $site_url ?>">
            <meta property="og:description" content="<?php echo $zon['config']['site_desc'] ?>">
            <meta property="og:site_name" content="<?php echo $zon['config']['site_name'] ?>">
            <meta property="og:image:width" content="630" />
            <meta property="og:image:height" content="630" />
            <meta name="twitter:card" content="summary">
            <meta name="twitter:site" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:creator" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:title" content="<?php echo $zon['config']['site_title'] ?>">
            <meta name="twitter:description" content="<?php echo $zon['config']['site_desc'] ?>">
            <meta name="twitter:image" content="<?php echo $site_url . 'static/logo/' . $zon['config']['site_logo_light'] ?>">
            <meta name="twitter:image:alt" content="<?php echo $zon['config']['site_title'] ?>">
            <meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST'] ?>">
            <link rel="alternate" hreflang="en" href="<?php echo $site_url ?>?cl=en" />
            <link rel="alternate" hreflang="es" href="<?php echo $site_url ?>?cl=es" />
            <link rel="alternate" hreflang="fr" href="<?php echo $site_url ?>?cl=fr" />
            <link rel="alternate" hreflang="de" href="<?php echo $site_url ?>?cl=de" />
            <link rel="alternate" hreflang="it" href="<?php echo $site_url ?>?cl=it" />
            <link rel="alternate" hreflang="pt" href="<?php echo $site_url ?>?cl=pt" />
            <link rel="alternate" hreflang="nl" href="<?php echo $site_url ?>?cl=nl" />
            <link rel="alternate" hreflang="ru" href="<?php echo $site_url ?>?cl=ru" />
            <link rel="alternate" hreflang="zh-Hans" href="<?php echo $site_url ?>?cl=zh-Hans" />
            <link rel="alternate" hreflang="zh-Hant" href="<?php echo $site_url ?>?cl=zh-Hant" />
            <link rel="alternate" hreflang="ja" href="<?php echo $site_url ?>?cl=ja" />
            <link rel="alternate" hreflang="ko" href="<?php echo $site_url ?>?cl=ko" />
            <link rel="alternate" hreflang="ar" href="<?php echo $site_url ?>?cl=ar" />
            <link rel="alternate" hreflang="tr" href="<?php echo $site_url ?>?cl=tr" />
            <link rel="alternate" hreflang="hi" href="<?php echo $site_url ?>?cl=hi" />
            <link rel="alternate" hreflang="bn" href="<?php echo $site_url ?>?cl=bn" />
            <link rel="alternate" hreflang="fa" href="<?php echo $site_url ?>?cl=fa" />
            <link rel="alternate" hreflang="el" href="<?php echo $site_url ?>?cl=el" />
            <link rel="alternate" hreflang="sv" href="<?php echo $site_url ?>?cl=sv" />
            <link rel="alternate" hreflang="no" href="<?php echo $site_url ?>?cl=no" />
            <link rel="alternate" hreflang="da" href="<?php echo $site_url ?>?cl=da" />
            <link rel="alternate" hreflang="fi" href="<?php echo $site_url ?>?cl=fi" />
            <link rel="alternate" hreflang="pl" href="<?php echo $site_url ?>?cl=pl" />
            <link rel="alternate" hreflang="hu" href="<?php echo $site_url ?>?cl=hu" />
        <?php } ?>
        <?php # meta tags for blog page      ?>
        <?php if ($zon['page'][0] == 'blog') {
            $blog = blogById($zon['page'][2]); ?>
            <meta name="description" content="<?php echo $blog['blog_desc'] ?>" />
            <link rel="canonical"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>" />
            <meta property="og:title" content="<?php echo $blog['blog_title'] ?>">
            <meta property="og:type" content="website">
            <meta property="og:image" content="<?php echo $site_url . 'static/blog/' . $blog['blog_image'] ?>">
            <meta property="og:url"
                content="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>">
            <meta property="og:description" content="<?php echo $blog['blog_desc'] ?>">
            <meta property="og:site_name" content="<?php echo $zon['config']['site_name'] ?>">
            <meta property="og:image:width" content="630" />
            <meta property="og:image:height" content="630" />
            <meta name="twitter:card" content="summary">
            <meta name="twitter:site" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:creator" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:title" content="<?php echo $blog['blog_title'] ?>">
            <meta name="twitter:description" content="<?php echo $blog['blog_desc'] ?>">
            <meta name="twitter:image" content="<?php echo $site_url . 'static/blog/' . $blog['blog_image'] ?>">
            <meta name="twitter:image:alt" content="<?php echo $blog['blog_title'] ?>">
            <meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST'] ?>">
            <link rel="alternate" hreflang="en"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/en">
            <link rel="alternate" hreflang="es"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/es">
            <link rel="alternate" hreflang="fr"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/fr">
            <link rel="alternate" hreflang="de"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/de">
            <link rel="alternate" hreflang="it"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/it">
            <link rel="alternate" hreflang="pt"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/pt">
            <link rel="alternate" hreflang="nl"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/nl">
            <link rel="alternate" hreflang="ru"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/ru">
            <link rel="alternate" hreflang="zh-Hans"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/zh-Hans">
            <link rel="alternate" hreflang="zh-Hant"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/zh-Hant">
            <link rel="alternate" hreflang="ja"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/ja">
            <link rel="alternate" hreflang="ko"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/ko">
            <link rel="alternate" hreflang="ar"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/ar">
            <link rel="alternate" hreflang="tr"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/tr">
            <link rel="alternate" hreflang="hi"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/hi">
            <link rel="alternate" hreflang="bn"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/bn">
            <link rel="alternate" hreflang="fa"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/fa">
            <link rel="alternate" hreflang="el"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/el">
            <link rel="alternate" hreflang="sv"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/sv">
            <link rel="alternate" hreflang="no"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/no">
            <link rel="alternate" hreflang="da"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/da">
            <link rel="alternate" hreflang="fi"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/fi">
            <link rel="alternate" hreflang="pl"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/pl">
            <link rel="alternate" hreflang="hu"
                href="<?php echo $site_url . 'blog/' . makeSlug($blog['blog_title']) . '/' . $blog['id'] ?>/hu">
        <?php } ?>
        <?php # meta tags for game page      ?>
        <?php if ($zon['page'][0] == 'game' && (count($zon['page']) == 3 || count($zon['page']) == 4) || $zon['page'][0] == 'single' && (count($zon['page']) == 3 || count($zon['page']) == 4)) {
            $play_title = $zon['config']['play_desc'];

            if ($zon['page'][0] == 'single') {
                $game = getGamesById($zon['page'][1]);
            }
            if ($zon['page'][0] == 'game') {
                $game = getGamesById($zon['page'][2]);
            }

            $game_desc = str_replace("[name]", $game['game_name'], $play_title);
            $game['game_description'] = $game_desc;
            ?>
            <meta name="description" content="<?php echo $game_desc ?>" />
            <link rel="canonical" href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>" />
            <meta property="og:title" content="<?php echo $game['game_name'] ?>">
            <meta property="og:type" content="website">
            <meta property="og:image" content="<?php echo $game['game_image_url'] ?>" />
            <meta property="og:url"
                content="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>">
            <meta property="og:description" content="<?php echo $game['game_description'] ?>">
            <meta property="og:site_name" content="<?php echo $zon['config']['site_name'] ?>">
            <meta property="og:image:width" content="630" />
            <meta property="og:image:height" content="630" />
            <meta name="twitter:card" content="summary">
            <meta name="twitter:site" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:creator" content="@<?php echo strtolower($zon['config']['site_name']) ?>">
            <meta name="twitter:title" content="<?php echo $game['game_name'] ?>">
            <meta name="twitter:description" content="<?php echo $game['game_description'] ?>">
            <meta name="twitter:image" content="<?php echo $game['game_image_url'] ?>">
            <meta name="twitter:image:alt" content="<?php echo $game['game_name'] ?>">
            <meta name="twitter:domain" content="<?php echo $_SERVER['HTTP_HOST'] ?>">
            <link rel="alternate" hreflang="en"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/en">
            <link rel="alternate" hreflang="es"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/es">
            <link rel="alternate" hreflang="fr"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/fr">
            <link rel="alternate" hreflang="de"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/de">
            <link rel="alternate" hreflang="it"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/it">
            <link rel="alternate" hreflang="pt"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/pt">
            <link rel="alternate" hreflang="nl"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/nl">
            <link rel="alternate" hreflang="ru"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/ru">
            <link rel="alternate" hreflang="zh-Hans"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/zh-Hans">
            <link rel="alternate" hreflang="zh-Hant"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/zh-Hant">
            <link rel="alternate" hreflang="ja"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/ja">
            <link rel="alternate" hreflang="ko"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/ko">
            <link rel="alternate" hreflang="ar"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/ar">
            <link rel="alternate" hreflang="tr"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/tr">
            <link rel="alternate" hreflang="hi"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/hi">
            <link rel="alternate" hreflang="bn"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/bn">
            <link rel="alternate" hreflang="fa"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/fa">
            <link rel="alternate" hreflang="el"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/el">
            <link rel="alternate" hreflang="sv"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/sv">
            <link rel="alternate" hreflang="no"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/no">
            <link rel="alternate" hreflang="da"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/da">
            <link rel="alternate" hreflang="fi"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/fi">
            <link rel="alternate" hreflang="pl"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/pl">
            <link rel="alternate" hreflang="hu"
                href="<?php echo $site_url . 'game/' . makeSlug($game['game_name']) . '/' . $game['id'] ?>/hu">
        <?php } ?>
        <?php if ($zon['page'][0] == 'new-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'newest')) { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'popular-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'popular')) { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'games') { ?>
            <meta name="description" content="<?php echo $zon['config']['games_desc'] ?>" />
        <?php } ?>
        <?php if ($zon['page'][0] == 'category' || $zon['page'][0] == 'game' && count($zon['page']) == 2) {
            $category_desc = $zon['config']['category_desc'];
            $title = str_replace("[name]", $_GET['n'] ?? '', $category_desc);
            ?>
            <meta name="description" content="<?php echo $title ?>" />
        <?php } ?>
        <meta name="robots" content="index, follow">
        <link rel="shortcut icon" href="<?php echo $site_url . 'static/img/logo/' . $zon['config']['site_favicon'] ?>"
            type="image/x-icon">
        <title>
            <?php getTitle(); ?>
        </title>
        <script src="<?php echo $site_url ?>js/tailwind.js"></script>
        <script src="<?php echo $site_url ?>js/toast.min.js"></script>
        <link rel="stylesheet" href="<?php echo $site_url ?>css/swiper.css" />
        <link rel="stylesheet" href="<?php echo $site_url ?>css/animate.css" />
        <link rel="stylesheet" href="<?php echo $site_url ?>css/toast.min.css" />
        <script src="<?php echo $site_url ?>js/wow.min.js"></script>
        <script>zontal = { url: "<?php echo $site_url ?>", ui: <?php echo $zon['user']['id'] ?? 0; ?> }</script>
        <?php echo $zon['config']['head_code'] ?>
        <style>
            html[zontal-theme="dark"] {
                --zon-body-bg-color: #111;
                --zon-common-text-color: #dcdcdc;
                --zon-theme-color:
                    <?php echo $zon['config']['site_color'] ?>
                ;
                --zon-div-color: #999;
                --zon-muted-color: #777;
                --zon-more-button-bg-color: #222;
                --zon-search-bg-color: #222;
                --zon-search-hover-color: #333;
                --zon-gmeta-bg-color: #222;
                --zon-overlay-bg-color: #000000af;
                --zon-cursor-color:
                    <?php echo $zon['config']['cursor_color'] ?>
                ;
                --zon-toggler-bg-color: #222;
                --zon-icon-color: #fff;
                --zon-dark-logo: block;
                --zon-light-logo: none;
                --zon-sidebar-shadow: 0px 0px 40px 0px #000;
                --zon-blog-social-button-bg-hover-color: #222;
                --zon-comment-input-b-color: #222;
            }

            html[zontal-theme="light"] {
                --zon-body-bg-color: #fff;
                --zon-common-text-color: #111;
                --zon-theme-color:
                    <?php echo $zon['config']['site_color'] ?>
                ;
                --zon-div-color: #999;
                --zon-muted-color: #777;
                --zon-more-button-bg-color: #dcdcdc;
                --zon-search-bg-color: #dcdcdc81;
                --zon-search-hover-color: #dcdcdc81;
                --zon-gmeta-bg-color: #dcdcdc81;
                --zon-overlay-bg-color: #000000c5;
                --zon-cursor-color:
                    <?php echo $zon['config']['cursor_color'] ?>
                ;
                --zon-toggler-bg-color: #dcdcdc;
                --zon-icon-color: #111;
                --zon-dark-logo: none;
                --zon-light-logo: block;
                --zon-sidebar-shadow: 0px 0px 40px 0px #111;
                --zon-blog-social-button-bg-hover-color: #dcdcdc;
                --zon-comment-input-b-color: #dcdcdc;
            }

            <?php if ($zon['config']['custom_cursor'] == 1) { ?>
                * {
                    cursor: none !important;
                    scroll-behavior: smooth;
                }

            <?php } ?>
        </style>
    </head>

    <body>
        <div class="flex">
            <?php if ($zon['page'][0] !== 'blog') { ?>
                <?php LoadFile('sidebar'); ?>
            <?php } ?>
            <div class="zontal-start w-full">
                <?php LoadFile('header'); ?>
                <?php if ($zon['page'][0] !== 'blog') { ?>
                    <div class="z-container">
                    <?php } ?>
                    <?php if ($zon['url'] == '') { ?>
                        <?php if ($zon['config']['featured_game_slider']) { ?>
                            <?php LoadFile('image-slider'); ?>
                        <?php } ?>
                        <div class="loop-section-start">
                            <?php LoadFile('dynamic-section'); ?>
                        </div>
                        <?php LoadFile('blog-section'); ?>
                    <?php } else if ($zon['page'][0] === 'blogs') { ?>
                        <?php LoadFile('blogs'); ?>
                    <?php } else if ($zon['page'][0] === 'register') { ?>
                        <?php LoadFile('register'); ?>
                    <?php } else if ($zon['page'][0] === 'logout') { ?>
                        <?php redirect('logout.php', 1); ?>
                    <?php } else if ($zon['page'][0] == 'games') { ?>
                        <?php LoadFile('all-games'); ?>
                    <?php } else if ($zon['page'][0] == 'new-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'newest')) { ?>
                        <?php LoadFile('newest-games'); ?>
                    <?php } else if ($zon['page'][0] == 'popular-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'popular')) { ?>
                        <?php LoadFile('popular-games'); ?>
                    <?php } else if ($zon['page'][0] == 'page' && count($zon['page']) == 3) {
                        $page_id = str_replace("-", " ", $zon['page'][1]);
                        if (num_rows(T_ZON_PAGES, "id=$page_id") > 0) {
                            LoadFile('page');
                        } else {
                            LoadFile('404');
                        }
                        ?>
                    <?php } else if ($zon['page'][0] == 'autoplay') { ?>
                        <?php LoadFile('autoplay'); ?>
                    <?php } else if ($zon['page'][0] == 'game' && (count($zon['page']) == 4 || count($zon['page']) == 3) || ($zon['page'][0] == 'single') && (count($zon['page']) == 4 || count($zon['page']) == 3)) {
                        $game_name = str_replace("-", " ", urldecode($zon['page'][1]));
                        if ($zon['page'][0] == 'single') {
                            $game_id = $zon['page'][1];
                        }
                        if ($zon['page'][0] == 'game' && (count($zon['page']) == 3 || count($zon['page']) == 4)) {
                            $game_id = $zon['page'][2];
                        }
                        if (
                            num_rows(T_ZON_GAMES, "id=$game_id") > 0
                        ) {
                            LoadFile('game');
                        } else {
                            LoadFile('404');
                        }
                        ?>
                    <?php } else if ($zon['page'][0] == 'category' || $zon['page'][0] == 'game' && count($zon['page']) == 2) {
                        $category_name = str_replace("-", " ", urldecode($_GET['n'] ?? $zon['page'][1]));
                        $zC = $zon['page'][1];
                        if (
                            num_rows(T_ZON_CATEGORY, "name='$category_name'") >= 0 || num_rows(T_ZON_CATEGORY, "name='$zC'") >= 0
                            // num_rows(T_ZON_CATEGORY, "name='$category_name'") > 0
                        ) {
                            LoadFile('category');
                        } else {
                            LoadFile('404');
                        }
                        ?>
                    <?php } else if ($zon['page'][0] == 'blog' && (count($zon['page']) == 4 || count($zon['page']) == 3)) {
                        $blog_name = str_replace("-", " ", urldecode($zon['page'][1]));
                        $blog_id = $zon['page'][2];
                        if (num_rows(T_ZON_BLOGS, "blog_title='$blog_name' && id=$blog_id ") > 0) {
                            LoadFile('blog-post');
                        } else {
                            LoadFile('404');
                        }
                        ?>
                    <?php } else if ($zon['page'][0] == 'login') { ?>
                        <?php LoadFile('login'); ?>
                    <?php } else if (num_rows(T_ZON_USERS, "username='" . $zon['page'][0] . "'") > 0 || $zon['page'][0] == 'user') { ?>
                        <?php LoadFile('user-profile'); ?>
                    <?php } else {
                        LoadFile('404');
                    } ?>
                    <?php if ($zon['page'][0] !== 'blog') { ?>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php if ($zon['config']['custom_cursor'] == 1) { ?>
            <?php LoadFile('cursor') ?>
        <?php } ?>
        <script> new WOW().init();  </script>
        <script src="<?php echo $site_url ?>themes/<?php echo $zon['config']['theme'] ?>/js/main.js"></script>
        <script src="<?php echo $site_url ?>js/jquery.min.js"></script>
        <?php if ($zon['page'][0] == 'games') { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/all-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'category' || ($zon['page'][0] == 'game' && count($zon['page']) == 2)) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/games-by-category.php", {
                        page: page_no,
                        category: '<?php echo urldecode($_GET['n'] ?? $zon['page'][1]); ?>'
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'new-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'newest')) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/new-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <?php if ($zon['page'][0] == 'popular-games' || ($zon['page'][0] == 'archive' && $zon['page'][1] == 'popular')) { ?>
            <script>
                var page_no = 1;

                LoadData();

                $(window).scroll(() => {
                    if ($(window).scrollTop() + $(window).height() > $(document).height() - 200) {
                        LoadData();
                    }
                })

                function LoadData() {
                    $.post("<?php echo $site_url ?>xhr/popular-games.php", {
                        page: page_no
                    }, (data) => {
                        // console.log(data);
                        $("#zon_games").append(data);
                        $("#zon-loader").hide();
                    });

                    page_no++;
                }
            </script>
        <?php } ?>
        <script>
            var page_no = 1;
            var loader = $("#zon-category-loader");

            LoadCategory();

            $(".cate-more-load").on("click", () => {
                LoadCategory();
            })

            function LoadCategory() {
                loader.html('<span class="block w-4 h-4 rounded-full border-4 border-[transparent] border-l-[var(--zon-theme-color)] animate-spin " ></span>');

                setTimeout(() => {
                    $.post("<?php echo $site_url ?>xhr/categories.php", {
                        page: page_no
                    }, (data) => {
                        $("#zon_categories").append(data);
                        $("#zon-category-loader").html('<svg xmlns="http://www.w3.org/2000/svg" width="24px" height="24px" fill="none" stroke-width="1.0" viewBox="0 0 24 24" color="#000000"><path stroke="#000000" stroke-width="1.0" style="stroke: var(--zon-common-text-color);" stroke-linecap="round" stroke-linejoin="round" d="m6 9 6 6 6-6"></path></svg> more');
                    });

                    page_no++;
                }, 1000);
            }
        </script>

        <script>
            var page_no = 1;
            var sLoader = $(".live-search-loader");
            var sinput = $(".live-search-input");
            var resBox = $(".search-result");
            var clicker = $(".clicker");

            clicker.hide();

            clicker.on("click", () => {
                resBox.hide();
                clicker.hide();
            })

            resBox.hide();
            LoadGameData();

            sinput.on('keyup', () => {
                LoadGameData();
                resBox.show();
                clicker.show();

            })


            function LoadGameData() {
                // setTimeout(() => {
                $.post("<?php echo $site_url ?>xhr/live-search.php", {
                    page: page_no,
                    query: sinput.val() ? sinput.val() : 'a',
                }, (data) => {
                    if (data == '') {
                        $("#live-games").html('game not found.')
                    }
                    $("#live-games").html(data);
                    sLoader.hide();
                });

                page_no++;
                // }, 1500);
            }
        </script>
        <?php if ($zon['page'][0] == '') { ?>
            <!-- <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/3.4.1/js/swiper.min.js"></script> -->
            <script src="<?php echo $site_url ?>js/swiper.js"></script>
            <script>
                var swiper = new Swiper(".swiper-container.two", {
                    effect: "coverflow",
                    loop: true,
                    centeredSlides: true,
                    slidesPerView: "auto",
                    parallax: true,
                    autoplay: 3000,
                    coverflow: {
                        rotate: 0,
                        stretch: 100,
                        depth: 150,
                        modifier: 1.5,
                        slideShadows: false,
                    },
                });
            </script>
        <?php } ?>
    </body>

    </html>
<?php } ?>